;;; 
;;; Virtual Disk Drive Project	- Jan 4,2002 - EJR (on plane from Wayne)
;;;
;;; ** Fri Jan 04 18:39:00 2002 **
;;;

;;;
;;; This routine exports the following symbols
;;; 
   global NextTrack           ; jump to next track
   global PrevTrack           ; jump to previous track
   global ZeroTrack	      ; jump to track zero (see track.h for macro version)

#include "vd.h"
#include "utility.h"
	
;;;*******************************************************************
;;; NAME:	ZeroTrackMacro()
;;;
;;; DESCR:	MACRO - resets things back to track 0
;;;		NOTE - this is a duplicate of the one in track.h
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- the index hole indicator isn't set by this routine
;;;*******************************************************************
ZeroTrackMacro:	macro
                movf	BASE_LO,W
                movwf	CURBASE_LO
                movf	BASE_HI,W
                movwf	CURBASE_HI
                clrf	CURTRACK
                endm
	
PROG1 CODE
		
;;;*******************************************************************
;;; NAME:	NextTrack()
;;;
;;; DESCR:	Jump to the next track.  Deals with roll-over issues.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- DOES NOT worry about moving beyond the last track
;;;		- 13 cycles for the routine
;;;*******************************************************************
NextTrack:
	movlw	'>'		; now loading depends upon this track
	movwf	TXREG		;   move indication (used to be for debugging)

		decf	TRACKS,W	; () get (tracks - 1) into W
		subwf	CURTRACK,W	; () compare to CURTRACK
		skpnz			; () if equal, on last track so
		return			; ()	don't move
	
		movf	TRACKBLOCKS,W	; (0)
		addwf	CURBASE_LO	; (1) bump to next track
		movf	REMAINDER,W	; (2) remainder may be zero you know
		addwf	CURBASE_LO	; (3) test add it in
		skpz			; (4)
		goto	NextNoRollOver	; (5)

NextRollOver:	incf	CURBASE_HI	; (6) increment high bits
		goto	NextDone	; (7) didn't roll-over any
		
NextNoRollOver:	subwf	CURBASE_LO	; (7) back-out remainder add
		
NextDone:	incf	CURTRACK	; (9)

		MemAddrSet		; (7) transfer curbase to memory ptrs

		return			; (11)

;;;*******************************************************************
;;; NAME:	PrevTrack()
;;;
;;; DESCR:	Jump to the previous track.  Deals with roll-over issues.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	- number of cycles dont matter
;;;*******************************************************************
PrevTrack:
	movlw	'<'		; DEBUGGING!
	movwf	TXREG		; DEBUGGING!

		movf	CURTRACK	; protect against moving below zero
		skpnz
		return
	
		movf	TRACKBLOCKS,W	; (0)
		subwf	CURBASE_LO	; (1) bump to previous track

		movf	REMAINDER,W	; (2) prepare for roll-over
					; (didn't affect carry bit)

		btfss	STATUS,C	; (3) check for roll-over
		decf	CURBASE_HI	; (4) lower high bits
		btfss	STATUS,C	; (5)
		subwf	CURBASE_LO	; (6) adjust for remainder

		decf	CURTRACK	; (7)
	
		MemAddrSet		; (8) transfer curbase to memory ptrs

		return			; (12)

;;;*******************************************************************
;;; NAME:	ZeroTrack()
;;;
;;; DESCR:	Reset back to zero track.  Uses ZeroTrackMacro.
;;;
;;; ARGS:	
;;;
;;; RETURNS:	
;;;
;;; NOTES:	
;;;*******************************************************************
ZeroTrack:
	ZeroTrackMacro
	MemAddrSet
	return

	END
